/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.config.system.ConfigProperties;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.controller.LoginSupportController;
import com.elitescloud.boot.auth.provider.provider.CaptchaProvider;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatManager;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import com.elitescloud.boot.exception.BusinessException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(this.configProperties);
    }

    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @Bean
    public WechatProvider wechatProvider(WechatProperties wechatProperties) {
        return new WechatProvider(wechatProperties);
    }

    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper, WechatManager wechatManager) {
        return new WechatTemplate(wechatManager::getAppSecret, redisHelper);
    }

    @Bean
    @ConditionalOnMissingBean
    public WechatManager wechatManagerDefault() {
        return appId -> {
            throw new BusinessException("\u6682\u65e0\u5b9e\u73b0");
        };
    }
}

