/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.provider.config.properties.Sso2Properties;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.controller.SsoClientSupportController;
import com.elitescloud.boot.auth.provider.sso2.controller.SsoServerSupportController;
import com.elitescloud.boot.auth.provider.sso2.support.SsoClientSupportProvider;
import com.elitescloud.boot.auth.provider.sso2.support.SsoServerSupportProvider;
import com.elitescloud.boot.auth.provider.sso2.support.impl.DefaultSsoClientSupportProvider;
import com.elitescloud.boot.auth.provider.sso2.support.impl.DefaultSsoServerSupportProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(value={Sso2Properties.class})
@Import(value={ServerConfig.class, ClientConfig.class})
class Sso2Config {
    private static final Logger log = LoggerFactory.getLogger(Sso2Config.class);

    Sso2Config() {
    }

    @ConditionalOnProperty(prefix="elitesland.authorization.sso.client", name={"enabled"}, havingValue="true")
    class ClientConfig {
        private final Sso2Properties sso2Properties;

        public ClientConfig(Sso2Properties sso2Properties) {
            this.sso2Properties = sso2Properties;
            log.info("\u542f\u7528\u5355\u70b9\u767b\u5f55\u5ba2\u6237\u7aef\uff0c\u670d\u52a1\u7aef\u5730\u5740\uff1a{}", (Object)sso2Properties.getClient().getServerAddr());
        }

        @Bean
        @ConditionalOnMissingBean
        public SsoClientSupportProvider defaultSsoClientSupportProvider(InternalAuthenticationGranter internalAuthenticationGranter) {
            return new DefaultSsoClientSupportProvider(this.sso2Properties, internalAuthenticationGranter);
        }

        @Bean
        public SsoClientSupportController ssoSupportController(SsoClientSupportProvider supportProvider) {
            return new SsoClientSupportController(supportProvider);
        }
    }

    @ConditionalOnProperty(prefix="elitesland.authorization.sso.server", name={"enabled"}, havingValue="true")
    class ServerConfig {
        private final Sso2Properties sso2Properties;

        public ServerConfig(Sso2Properties sso2Properties) {
            this.sso2Properties = sso2Properties;
            log.info("\u542f\u7528\u5355\u70b9\u767b\u5f55\u670d\u52a1\u7aef");
        }

        @Bean
        @ConditionalOnMissingBean
        public SsoServerSupportProvider defaultSsoServerSupportProvider(RedisUtils redisUtils, AuthorizationSdkProperties sdkProperties) {
            return new DefaultSsoServerSupportProvider(this.sso2Properties, redisUtils, sdkProperties);
        }

        @Bean
        public SsoServerSupportController ssoSupportController(SsoServerSupportProvider supportProvider) {
            return new SsoServerSupportController(supportProvider);
        }
    }
}

