/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.provider.config.system.ConfigProperties;
import com.elitescloud.boot.auth.provider.config.system.TenantProperties;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.spring.web.plugins.Docket;

@EnableConfigurationProperties(value={ConfigProperties.class, WechatProperties.class, TenantProperties.class})
@EnableScheduling
@EnableCaching
@Import(value={TenantConfig.class, SwaggerConfig.class})
@ConditionalOnClass(value={CloudtCoreAutoConfiguration.class})
class SystemConfig {
    private static final Logger log = LogManager.getLogger(SystemConfig.class);

    SystemConfig() {
    }

    @ConditionalOnProperty(prefix="knife4j", name={"enable"}, havingValue="true")
    static class SwaggerConfig
    extends BaseSwaggerConfig {
        public SwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
            super(openApiExtensionResolver, serverProperties);
        }

        @Bean
        public Docket createAuthProviderRestApi() {
            return this.createDocket("AuthorizationSupportAPI", new String[]{"com.elitescloud.boot.auth"});
        }
    }

    @ConditionalOnClass(value={TenantClient.class})
    static class TenantConfig {
        TenantConfig() {
        }

        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties, TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }
}

