/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.properties;

import com.elitescloud.boot.auth.sso.common.SsoAccountType;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="elitesland.authorization.sso")
public class Sso2Properties {
    public static final String CONFIG_PREFIX = "elitesland.authorization.sso";
    @NestedConfigurationProperty
    private Server server = new Server();
    @NestedConfigurationProperty
    private Client client = new Client();

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public static class Client {
        private Boolean enabled = false;
        private String serverAddr;
        private String clientId;
        private String clientSecret;
        private SsoAccountType accountType = SsoAccountType.USER_NAME;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getServerAddr() {
            return this.serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public SsoAccountType getAccountType() {
            return this.accountType;
        }

        public void setAccountType(SsoAccountType accountType) {
            this.accountType = accountType;
        }
    }

    public static class Server {
        private Boolean enabled = false;
        private Duration ticketTtl = Duration.ofMinutes(30L);
        private Boolean expireTicketOnUsed = true;
        private Boolean validateClient = true;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getTicketTtl() {
            return this.ticketTtl;
        }

        public void setTicketTtl(Duration ticketTtl) {
            this.ticketTtl = ticketTtl;
        }

        public Boolean getExpireTicketOnUsed() {
            return this.expireTicketOnUsed;
        }

        public void setExpireTicketOnUsed(Boolean expireTicketOnUsed) {
            this.expireTicketOnUsed = expireTicketOnUsed;
        }

        public Boolean getValidateClient() {
            return this.validateClient;
        }

        public void setValidateClient(Boolean validateClient) {
            this.validateClient = validateClient;
        }
    }
}

