/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet;

import com.elitescloud.boot.auth.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.provider.config.LoginSupportConfig;
import com.elitescloud.boot.auth.provider.security.configurer.LoginFilterSecurityConfigurer;
import com.elitescloud.boot.auth.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.boot.auth.provider.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.boot.auth.provider.security.handler.JwtAuthenticationSuccessHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="single")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={LoginSupportConfig.class})
public class ServletSingleConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletSingleConfig.class);
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;
    private TokenGenerator tokenGenerator;

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        JwtAuthenticationSuccessHandler successHandler = new JwtAuthenticationSuccessHandler(this.authorizationProperties, DelegateAuthenticationCallable.getInstance(), this.tokenGenerator);
        ((LoginFilterSecurityConfigurer)((Object)((LoginFilterSecurityConfigurer)super.defaultSecurityConfig(http).apply(new LoginFilterSecurityConfigurer<HttpSecurity>(this.loginFilterCustomizers))).successHandler(successHandler))).failureHandler(new DefaultAuthenticationFailureHandler((AuthenticationCallable)DelegateAuthenticationCallable.getInstance()));
        return (SecurityFilterChain)http.build();
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }

    @Autowired
    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

