/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config.servlet.oauth2.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.boot.auth.provider.security.handler.LogoutRedirectHandler;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class OAuth2ServerLogoutRedirectHandler
implements LogoutRedirectHandler {
    private final RegisteredClientRepository registeredClientRepository;
    private final AuthorizationProperties authorizationProperties;
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private UniqueRequestResolver uniqueRequestResolver = null;
    private RequestCache requestCache;

    public OAuth2ServerLogoutRedirectHandler(RegisteredClientRepository registeredClientRepository, AuthorizationProperties authorizationProperties, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationProperties = authorizationProperties;
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    @Override
    public String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response) {
        SavedRequest savedRequest = null;
        if (this.requestCache != null) {
            savedRequest = this.requestCache.getRequest(request, response);
        }
        String clientId = null;
        if (savedRequest != null) {
            String redirectUri = this.obtainRequestParam(savedRequest, "redirect_uri");
            if (StringUtils.hasText((String)redirectUri)) {
                return redirectUri;
            }
            clientId = this.obtainRequestParam(savedRequest, "client_id");
        }
        if (CharSequenceUtil.isBlank(clientId)) {
            clientId = this.obtainClientId(request);
        }
        if (CharSequenceUtil.isBlank(clientId)) {
            return null;
        }
        RegisteredClient client = this.registeredClientRepository.findByClientId(clientId);
        if (client == null) {
            return null;
        }
        String loginUrl = (String)client.getClientSettings().getSetting("loginUrl");
        if (StringUtils.hasText((String)loginUrl)) {
            return loginUrl;
        }
        return this.authorizationProperties.getLoginPage();
    }

    private String obtainRequestParam(SavedRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private String obtainClientId(HttpServletRequest request) {
        OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken;
        String reqId;
        if (this.uniqueRequestResolver != null && StringUtils.hasText((String)(reqId = this.uniqueRequestResolver.analyze(request))) && (authenticationToken = this.authorizationCodeRequestCache.getAuthenticationToken(reqId)) != null) {
            return authenticationToken.getClientId();
        }
        return null;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

