/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider;

import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;

public class PwdExpiredTimeProvider<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private static final Logger log = LoggerFactory.getLogger(PwdExpiredTimeProvider.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final PwdStrategyTransferHelper pwdStrategyTransferHelper;

    public PwdExpiredTimeProvider(AuthorizationSdkProperties sdkProperties, PwdStrategyTransferHelper pwdStrategyTransferHelper) {
        this.sdkProperties = sdkProperties;
        this.pwdStrategyTransferHelper = pwdStrategyTransferHelper;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        if (Boolean.FALSE.equals(this.sdkProperties.getVerifyPwdExpiredTime())) {
            log.debug("\u4e0d\u6821\u9a8c\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4");
            return;
        }
        if (userDetails.getUser().getPwdExpiredTime() != null) {
            return;
        }
        Long casUserId = userDetails.getUser().getCasUserId();
        if (casUserId == null) {
            log.debug("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u7528\u6237ID\u4e3a\u7a7a\uff0c\u65e0\u9700\u83b7\u53d6\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4");
            return;
        }
        Result queryResult = null;
        try {
            queryResult = this.pwdStrategyTransferHelper.getLoginUserDetailExtend(casUserId);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8d26\u53f7\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38\uff1a{}", (Object)casUserId, (Object)e);
            return;
        }
        if (Boolean.FALSE.equals(queryResult.getSuccess())) {
            log.error("\u67e5\u8be2\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4\u5931\u8d25\uff1a{}\uff0c{}", (Object)casUserId, (Object)queryResult.getMsg());
            return;
        }
        if (queryResult.getData() == null) {
            log.warn("\u5728\u8ba4\u8bc1\u4e2d\u5fc3\u672a\u67e5\u8be2\u5230\u7528\u6237\u6570\u636e\uff1a{}", (Object)casUserId);
            return;
        }
        UserDetailExtendDTO userDetailExtendDTO = (UserDetailExtendDTO)queryResult.getData();
        if (userDetailExtendDTO.getNeedReset() != null) {
            userDetails.getUser().setNeedReset(userDetailExtendDTO.getNeedReset());
        }
        userDetails.getUser().setPwdExpiredTime(userDetailExtendDTO.getPwdExpiredTime());
    }
}

