/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.provider.wechat;

import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatAccessToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatPhoneInfo;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatToken;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

class WechatTool {
    private static final Logger log = LogManager.getLogger(WechatTool.class);
    private final RestTemplate restTemplate = RestTemplateFactory.instance();
    private final ObjectMapper objectMapper = new ObjectMapper();

    private WechatTool() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static WechatTool getInstance() {
        return new WechatTool();
    }

    public WechatToken getAccessToken(@NotBlank String appId, @NotBlank String appSecret) {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
        String resp = this.execGet(url = url.replace("APPID", appId).replace("APPSECRET", appSecret));
        if (StringUtils.hasText((String)resp)) {
            log.info("\u5fae\u4fe1\u83b7\u53d6AccessToken\uff1a{}", (Object)resp);
            try {
                return (WechatToken)this.objectMapper.readValue(resp, (TypeReference)new TypeReference<WechatToken>(){});
            }
            catch (JsonProcessingException e) {
                log.error("\u83b7\u53d6\u5fae\u4fe1access_token\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u670d\u52a1\u83b7\u53d6access_token\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public WechatPhoneInfo getPhoneNumber(@NotBlank String accessToken, @NotBlank String code) {
        String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=ACCESS_TOKEN";
        String resp = this.execPost(url = url.replace("ACCESS_TOKEN", accessToken), Map.of("code", code));
        if (StringUtils.hasText((String)resp)) {
            log.info("\u5fae\u4fe1\u83b7\u53d6\u624b\u673a\u53f7\uff1a{}", (Object)resp);
            try {
                return (WechatPhoneInfo)this.objectMapper.readValue(resp, (TypeReference)new TypeReference<WechatPhoneInfo>(){});
            }
            catch (JsonProcessingException e) {
                log.error("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u670d\u52a1\u83b7\u53d6\u624b\u673a\u53f7\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public WechatAccessToken oauth2AccessToken(@NonNull String appId, @NonNull String secret, @NonNull String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";
        String resp = this.execGet(url = url.replace("APPID", appId).replace("SECRET", secret).replace("CODE", code));
        if (StringUtils.hasText((String)resp)) {
            try {
                return (WechatAccessToken)this.objectMapper.readValue(resp, (TypeReference)new TypeReference<WechatAccessToken>(){});
            }
            catch (JsonProcessingException e) {
                log.error("\u8f6c\u6362\u5fae\u4fe1access_token\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u670d\u52a1\u83b7\u53d6access_token\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public WechatUserInfo snsUserInfo(String accessToken, String openId) {
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
        String resp = this.execGet(url = url.replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId));
        if (StringUtils.hasText((String)resp)) {
            try {
                return (WechatUserInfo)this.objectMapper.readValue(resp, (TypeReference)new TypeReference<WechatUserInfo>(){});
            }
            catch (JsonProcessingException e) {
                log.error("\u8f6c\u6362\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u670d\u52a1\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    private String execGet(String url) {
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\uff1a{}", (Object)url);
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            log.info("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}, {}", (Object)resp.getStatusCode(), resp.getBody());
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (String)resp.getBody();
            }
        }
        catch (RestClientException e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private String execPost(String url, Object entity) {
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\uff1a{}", (Object)url);
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(entity), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            log.info("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}, {}", (Object)resp.getStatusCode(), resp.getBody());
            if (resp.getStatusCode().is2xxSuccessful()) {
                return (String)resp.getBody();
            }
        }
        catch (RestClientException e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

