/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant;

import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.CustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.config.system.ConfigProperties;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.grant.CredentialCheckable;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class AbstractCustomAuthenticationProvider<T extends AbstractCustomAuthenticationToken<T>>
implements CustomAuthenticationProvider {
    private static final Logger log = LogManager.getLogger(AbstractCustomAuthenticationProvider.class);
    private boolean forcePrincipalAsString = false;
    private boolean hideUserNotFoundExceptions = true;
    private UserDetailsChecker preAuthenticationChecks = new DefaultPreAuthenticationChecks();
    private UserDetailsChecker postAuthenticationChecks = new DefaultPostAuthenticationChecks();
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();
    private Class<T> tokenClazz;
    protected PasswordEncoder passwordEncoder;
    protected UserDetailManager userDetailManager;
    protected ConfigProperties configProperties;
    protected CredentialCheckable credentialCheckable;
    private ObjectProvider<AuthenticationCheckService> authenticationCheckServiceObjectProvider;

    @NonNull
    protected abstract GeneralUserDetails retrieveUser(T var1) throws AuthenticationException;

    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        this.customAdditionalAuthenticationChecks(userDetails, authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AbstractCustomAuthenticationToken authenticationToken = (AbstractCustomAuthenticationToken)authentication;
        GeneralUserDetails user = null;
        try {
            user = this.retrieveUser(authenticationToken);
        }
        catch (UsernameNotFoundException ex) {
            if (!this.hideUserNotFoundExceptions) {
                throw ex;
            }
            log.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", authentication.getPrincipal());
            throw new BadCredentialsException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        this.preAuthenticationChecks.check((UserDetails)user);
        this.additionalAuthenticationChecks(user, authenticationToken);
        this.postAuthenticationChecks.check((UserDetails)user);
        Object principalToReturn = user;
        if (this.forcePrincipalAsString) {
            principalToReturn = user.getUsername();
        }
        return this.createSuccessAuthentications(principalToReturn, authenticationToken, user);
    }

    public boolean supports(Class<?> authentication) {
        return this.getAuthenticationTokenType().isAssignableFrom(authentication);
    }

    public Class<T> getAuthenticationTokenType() {
        this.analyzeTokenType();
        return this.tokenClazz;
    }

    public boolean isHideUserNotFoundExceptions() {
        return this.hideUserNotFoundExceptions;
    }

    public void setHideUserNotFoundExceptions(boolean hideUserNotFoundExceptions) {
        this.hideUserNotFoundExceptions = hideUserNotFoundExceptions;
    }

    public UserDetailsChecker getPreAuthenticationChecks() {
        return this.preAuthenticationChecks;
    }

    public void setPreAuthenticationChecks(UserDetailsChecker preAuthenticationChecks) {
        this.preAuthenticationChecks = preAuthenticationChecks;
    }

    public UserDetailsChecker getPostAuthenticationChecks() {
        return this.postAuthenticationChecks;
    }

    public void setPostAuthenticationChecks(UserDetailsChecker postAuthenticationChecks) {
        this.postAuthenticationChecks = postAuthenticationChecks;
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    @Autowired(required=false)
    public void setUserDetailManager(UserDetailManager userDetailManager) {
        this.userDetailManager = userDetailManager;
    }

    @Autowired
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Autowired
    public void setConfigProperties(ConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Autowired
    public void setAuthenticationCheckServiceObjectProvider(ObjectProvider<AuthenticationCheckService> authenticationCheckServiceObjectProvider) {
        this.authenticationCheckServiceObjectProvider = authenticationCheckServiceObjectProvider;
    }

    @Autowired
    public void setCredentialCheckable(CredentialCheckable credentialCheckable) {
        this.credentialCheckable = credentialCheckable;
    }

    private void analyzeTokenType() {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        if (this.tokenClazz != null) {
            return;
        }
        Type superType = this.getClass().getGenericSuperclass();
        if (superType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)superType).getActualTypeArguments()).length > 0) {
            for (Type typeArgument : typeArguments) {
                if (!AbstractCustomAuthenticationToken.class.isAssignableFrom((Class)typeArgument)) continue;
                this.tokenClazz = (Class)typeArgument;
            }
        }
        Objects.requireNonNull(this.tokenClazz, () -> this.getClass().getName() + "\u672a\u77e5\u6cdb\u578btoken\u7c7b\u578b");
    }

    private void customAdditionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) {
        for (AuthenticationCheckService authenticationCheckService : this.authenticationCheckServiceObjectProvider) {
            authenticationCheckService.additionalAuthenticationChecks(userDetails, authentication);
        }
    }

    private Authentication createSuccessAuthentications(Object principal, T authentication, GeneralUserDetails user) {
        AbstractCustomAuthenticationToken result = null;
        Collection authorities = this.authoritiesMapper.mapAuthorities(user.getAuthorities());
        try {
            Constructor<T> tokenConstructor = this.tokenClazz.getDeclaredConstructor(Object.class, Object.class, Collection.class);
            result = (AbstractCustomAuthenticationToken)tokenConstructor.newInstance(principal, authentication.getCredentials(), authorities);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("\u521b\u5efaAuthentication Success Token\u5931\u8d25", (Throwable)e);
        }
        result.setPrincipal(principal);
        result.setDetails(authentication.getDetails());
        result.setTerminal(authentication.getTerminal());
        log.debug("Authenticated user");
        return result;
    }

    private static class DefaultPostAuthenticationChecks
    implements UserDetailsChecker {
        private DefaultPostAuthenticationChecks() {
        }

        public void check(UserDetails user) {
            if (!user.isCredentialsNonExpired()) {
                log.debug("Failed to authenticate since user account credentials have expired");
                throw new CredentialsExpiredException("\u5bc6\u7801\u5df2\u8fc7\u671f");
            }
        }
    }

    private static class DefaultPreAuthenticationChecks
    implements UserDetailsChecker {
        private DefaultPreAuthenticationChecks() {
        }

        public void check(UserDetails user) {
            if (user == null) {
                throw new UsernameNotFoundException("\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            if (!user.isAccountNonLocked()) {
                log.debug("Failed to authenticate since user account is locked");
                throw new LockedException("\u8d26\u53f7\u5df2\u9501\u5b9a");
            }
            if (!user.isEnabled()) {
                log.debug("Failed to authenticate since user account is disabled");
                throw new DisabledException("\u8d26\u53f7\u5df2\u7981\u7528");
            }
            if (!user.isAccountNonExpired()) {
                log.debug("Failed to authenticate since user account has expired");
                throw new AccountExpiredException("\u8d26\u53f7\u5df2\u8fc7\u671f");
            }
        }
    }
}

