/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.email_code;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class EmailCodeAuthenticationToken
extends AbstractCustomAuthenticationToken<EmailCodeAuthenticationToken> {
    private static final long serialVersionUID = -8359205420429608593L;
    private boolean autoRegister = false;

    public EmailCodeAuthenticationToken() {
        super(null, null);
    }

    public EmailCodeAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public EmailCodeAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.EMAIL_CODE;
    }

    @NonNull
    public EmailCodeAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.parse((String)terminalParam);
        }
        EmailCodeAuthenticationToken authenticationToken = new EmailCodeAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"email"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"code"));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        return authenticationToken;
    }

    boolean isAutoRegister() {
        return this.autoRegister;
    }

    void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }
}

