/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.email_pwd;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.email_pwd.EmailPasswordAuthenticationToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class EmailPasswordAuthenticationProvider
extends AbstractCustomAuthenticationProvider<EmailPasswordAuthenticationToken> {
    private static final Logger log = LoggerFactory.getLogger(EmailPasswordAuthenticationProvider.class);
    @Autowired
    private LoginSupportProvider loginSupportManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(EmailPasswordAuthenticationToken authentication) throws AuthenticationException {
        String email = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)email)) {
            throw new AuthorizationException("\u90ae\u7bb1\u4e3a\u7a7a");
        }
        this.checkCaptcha(authentication);
        GeneralUserDetails user = this.userDetailManager.loadUserByEmail(email);
        if (user == null) {
            throw new AuthorizationException("\u90ae\u7bb1\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return user;
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, EmailPasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (!this.credentialCheckable.needCheck(authentication, userDetails)) {
            return;
        }
        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("\u90ae\u7bb1\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("\u90ae\u7bb1\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkCaptcha(EmailPasswordAuthenticationToken authentication) {
        Boolean need = authentication.getCaptchaNeeded();
        if (need != null && !need.booleanValue()) {
            return;
        }
        ApiResult<Boolean> verifyResult = this.loginSupportManager.verifyCaptcha(authentication.getCaptchaKey(), authentication.getCaptchaText());
        if (!verifyResult.isSuccess()) {
            throw new AuthorizationException(verifyResult.getMsg());
        }
        if (verifyResult.getData() == null || !((Boolean)verifyResult.getData()).booleanValue()) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

