/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.email_pwd;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class EmailPasswordAuthenticationToken
extends AbstractCustomAuthenticationToken<EmailPasswordAuthenticationToken> {
    private static final long serialVersionUID = 6652438285763663860L;
    private String captchaText;
    private String captchaKey;
    private Boolean captchaNeeded;

    public EmailPasswordAuthenticationToken() {
        super(null, null);
    }

    public EmailPasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public EmailPasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.EMAIL_PWD;
    }

    @NonNull
    public EmailPasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        String captchaNeededStr;
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        boolean captchaNeeded = CharSequenceUtil.isBlank((CharSequence)(captchaNeededStr = (String)parameters.getFirst((Object)"captcha_needed"))) || Boolean.parseBoolean(captchaNeededStr);
        EmailPasswordAuthenticationToken authenticationToken = new EmailPasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"email"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"password"));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setCaptchaText((String)parameters.getFirst((Object)"captcha"));
        authenticationToken.setCaptchaKey((String)parameters.getFirst((Object)"capuid"));
        authenticationToken.setCaptchaNeeded(captchaNeeded);
        return authenticationToken;
    }

    public String getCaptchaText() {
        return this.captchaText;
    }

    public void setCaptchaText(String captchaText) {
        this.captchaText = captchaText;
    }

    public String getCaptchaKey() {
        return this.captchaKey;
    }

    public void setCaptchaKey(String captchaKey) {
        this.captchaKey = captchaKey;
    }

    public Boolean getCaptchaNeeded() {
        return this.captchaNeeded;
    }

    public void setCaptchaNeeded(Boolean captchaNeeded) {
        this.captchaNeeded = captchaNeeded;
    }
}

