/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.mobile_pwd;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.mobile_pwd.MobilePasswordAuthenticationToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class MobilePasswordAuthenticationProvider
extends AbstractCustomAuthenticationProvider<MobilePasswordAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(MobilePasswordAuthenticationProvider.class);
    @Autowired
    private LoginSupportProvider loginSupportManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)mobile)) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        this.checkCaptcha(authentication);
        GeneralUserDetails user = this.userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return user;
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (!this.credentialCheckable.needCheck(authentication, userDetails)) {
            return;
        }
        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkCaptcha(MobilePasswordAuthenticationToken authentication) {
        Boolean need = authentication.getCaptchaNeeded();
        if (need != null && !need.booleanValue()) {
            return;
        }
        ApiResult<Boolean> verifyResult = this.loginSupportManager.verifyCaptcha(authentication.getCaptchaKey(), authentication.getCaptchaText());
        if (!verifyResult.isSuccess()) {
            throw new AuthorizationException(verifyResult.getMsg());
        }
        if (verifyResult.getData() == null || !((Boolean)verifyResult.getData()).booleanValue()) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

