/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.password;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class UsernamePasswordAuthenticationToken
extends AbstractCustomAuthenticationToken<UsernamePasswordAuthenticationToken> {
    private static final long serialVersionUID = 3291894847806095884L;
    private String captchaText;
    private String captchaKey;
    private Boolean captchaNeeded;

    public UsernamePasswordAuthenticationToken() {
        super(null, null);
    }

    public UsernamePasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public UsernamePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    public LoginType loginType() {
        return LoginType.PASSWORD;
    }

    @NonNull
    public UsernamePasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        String captchaNeededStr;
        MultiValueMap parameters = HttpServletUtil.getParameters((HttpServletRequest)request);
        String terminalParam = (String)parameters.getFirst((Object)"terminal");
        Terminal terminal = null;
        if (StringUtils.hasText((String)terminalParam)) {
            terminal = Terminal.valueOf((String)terminalParam);
        }
        Boolean captchaNeeded = !StringUtils.hasText((String)(captchaNeededStr = (String)parameters.getFirst((Object)"captcha_needed"))) || Boolean.parseBoolean(captchaNeededStr);
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst((Object)"username"));
        authenticationToken.setCredentials(parameters.getFirst((Object)"password"));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setCaptchaText((String)parameters.getFirst((Object)"captcha"));
        authenticationToken.setCaptchaKey((String)parameters.getFirst((Object)"capuid"));
        authenticationToken.setCaptchaNeeded(captchaNeeded);
        authenticationToken.setIdentity((String)parameters.getFirst((Object)"identity"));
        return authenticationToken;
    }

    public String getCaptchaText() {
        return this.captchaText;
    }

    public String getCaptchaKey() {
        return this.captchaKey;
    }

    public Boolean getCaptchaNeeded() {
        return this.captchaNeeded;
    }

    public void setCaptchaText(String captchaText) {
        this.captchaText = captchaText;
    }

    public void setCaptchaKey(String captchaKey) {
        this.captchaKey = captchaKey;
    }

    public void setCaptchaNeeded(Boolean captchaNeeded) {
        this.captchaNeeded = captchaNeeded;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

