/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.security.grant.wechat_minapp;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatUserInfo;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.wechat_minapp.WechatMinAppAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class WechatMinAppAuthenticationProvider
extends AbstractCustomAuthenticationProvider<WechatMinAppAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(WechatMinAppAuthenticationProvider.class);
    @Autowired
    private WechatProvider wechatProvider;

    @Override
    protected GeneralUserDetails retrieveUser(WechatMinAppAuthenticationToken authentication) throws AuthenticationException {
        String openId = authentication.getOpenId();
        String appId = (String)authentication.getPrincipal();
        String wxCode = (String)authentication.getCredentials();
        if (StringUtils.hasText((String)openId)) {
            GeneralUserDetails user = this.userDetailManager.loadUserByWechatOpenid(openId);
            if (user == null) {
                throw new UsernameNotFoundException("\u8be5\u5fae\u4fe1\u672a\u7ed1\u5b9a\u8d26\u53f7");
            }
            return user;
        }
        if (!StringUtils.hasText((String)appId) || !StringUtils.hasText((String)wxCode)) {
            throw new AuthorizationException("\u8bf7\u6c42\u6709\u8bef\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        openId = this.obtainOpenid(appId, wxCode);
        GeneralUserDetails user = this.userDetailManager.loadUserByWechatOpenid(openId);
        if (user == null) {
            throw new UsernameNotFoundException("\u8be5\u5fae\u4fe1\u672a\u7ed1\u5b9a\u8d26\u53f7");
        }
        return user;
    }

    private String obtainOpenid(String appId, String wxCode) {
        try {
            WechatUserInfo userInfo = this.wechatProvider.getUserInfo(appId, wxCode);
            if (userInfo != null) {
                return userInfo.getOpenid();
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("\u5fae\u4fe1\u670d\u52a1\u6388\u6743\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

