/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.config.properties.Sso2Properties;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.support.SsoClientSupportProvider;
import com.elitescloud.boot.auth.sso.common.SsoAccountType;
import com.elitescloud.boot.auth.util.AuthorizationUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class DefaultSsoClientSupportProvider
implements SsoClientSupportProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsoClientSupportProvider.class);
    private static final String URI_USER_INFO = "/oauth/sso/v2/getUserByTicket";
    protected final Sso2Properties sso2Properties;
    private final InternalAuthenticationGranter internalAuthenticationGranter;
    protected final RestTemplateHelper restTemplateHelper;

    public DefaultSsoClientSupportProvider(Sso2Properties sso2Properties, InternalAuthenticationGranter internalAuthenticationGranter) {
        this.sso2Properties = sso2Properties;
        this.internalAuthenticationGranter = internalAuthenticationGranter;
        this.restTemplateHelper = this.buildRestTemplateHelper(sso2Properties.getClient());
    }

    @Override
    public ApiResult<OAuthToken> ticket2Token(HttpServletRequest request, HttpServletResponse response, String ticket) {
        if (CharSequenceUtil.isBlank((CharSequence)ticket)) {
            return ApiResult.fail((String)"\u7968\u636eticket\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        SysUserDTO userInfo = this.getUserByTicket(ticket);
        if (userInfo == null) {
            return ApiResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = this.convertAuthenticationToken(userInfo);
        if (authenticationToken == null) {
            return ApiResult.fail((String)"\u8f6c\u6362\u8ba4\u8bc1\u4ee4\u724c\u5931\u8d25");
        }
        OAuthToken token = null;
        try {
            token = this.internalAuthenticationGranter.authenticate(request, response, authenticationToken);
        }
        catch (AuthenticationException e) {
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38\uff0c" + e.getMessage()));
        }
        return ApiResult.ok((Object)token);
    }

    protected InternalAuthenticationGranter.InternalAuthenticationToken convertAuthenticationToken(SysUserDTO userDTO) {
        SsoAccountType accountType = this.sso2Properties.getClient().getAccountType();
        switch (accountType) {
            case USER_ID: {
                return new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USER_ID, userDTO.getId().toString());
            }
            case USER_NAME: {
                return new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USERNAME, userDTO.getUsername());
            }
            case EMAIL: {
                return new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.EMAIL, userDTO.getEmail());
            }
            case MOBILE: {
                return new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.MOBILE, userDTO.getMobile());
            }
        }
        throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u7c7b\u578b\uff1a" + accountType);
    }

    protected SysUserDTO getUserByTicket(String ticket) {
        String uri = this.buildUriOfGetUser(ticket);
        ApiResult userResult = (ApiResult)this.restTemplateHelper.exchangeSafely(uri, HttpMethod.GET, null, (TypeReference)new TypeReference<ApiResult<SysUserDTO>>(){}, new Object[0]);
        if (userResult != null && userResult.getData() != null) {
            return (SysUserDTO)userResult.getData();
        }
        log.info("\u6839\u636eticket\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff1a{}\uff0c{}", (Object)ticket, (Object)userResult);
        return null;
    }

    protected String buildUriOfGetUser(String ticket) {
        return "/oauth/sso/v2/getUserByTicket?ticket=" + URLEncoder.encode(ticket, StandardCharsets.UTF_8);
    }

    protected RestTemplateHelper buildRestTemplateHelper(Sso2Properties.Client client) {
        Assert.hasText((String)client.getServerAddr(), (String)"SSO\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a");
        RestTemplate restTemplate = RestTemplateFactory.instance(builder -> builder.rootUri(client.getServerAddr()).additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor(client.getClientId(), client.getClientSecret())}));
        return RestTemplateHelper.instance((RestTemplate)restTemplate);
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String token;

        public AuthorizationInterceptor(String clientId, String clientSecret) {
            Assert.hasText((String)clientId, (String)"\u5ba2\u6237\u7aefID\u4e3a\u7a7a");
            Assert.hasText((String)clientSecret, (String)"\u5ba2\u6237\u7aef\u5bc6\u7801\u4e3a\u7a7a");
            try {
                this.token = AuthorizationUtil.encodeBasicAuth((String)clientId, (String)clientSecret);
            }
            catch (IOException e) {
                throw new IllegalStateException("\u521d\u59cb\u5316sso\u5ba2\u6237\u7aef\u5f02\u5e38", e);
            }
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            headers.add("Authorization", this.token);
            return execution.execute(request, body);
        }
    }
}

