package com.elitescloud.boot.auth.provider.cas.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.provider.common.AuthorizationConstant;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.boot.auth.provider.config.properties.TokenProperties;
import com.elitescloud.boot.auth.provider.provider.DefaultTokenPropertiesProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * token属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/18
 */
@Slf4j
public class CasTokenPropertiesProvider extends DefaultTokenPropertiesProvider {

    private final AuthorizationProperties authorizationProperties;
    private final AuthorizationSdkProperties sdkProperties;
    private final UserTransferHelper userTransferHelper;

    public CasTokenPropertiesProvider(AuthorizationProperties authorizationProperties,
                                      AuthorizationSdkProperties sdkProperties) {
        super(authorizationProperties);
        this.authorizationProperties = authorizationProperties;
        this.sdkProperties = sdkProperties;
        this.userTransferHelper = UserTransferHelper.getInstance(sdkProperties.getAuthServer());
        log.info("CAS Client token configuration will be used");
    }

    @Override
    public TokenProperties get() {
        var request = HttpServletUtil.currentRequest();
        if (request == null || Boolean.FALSE.equals(sdkProperties.getCasClient().getEnabled())) {
            return this.defaultTokenProperties();
        }

        UserDetailExtendDTO userDetailExtendDTO = (UserDetailExtendDTO) request.getAttribute(AuthorizationConstant.REQUEST_ATTRIBUTE_AUTH_USER_DETAIL_EXTEND);
        if (userDetailExtendDTO != null) {
            TokenProperties tokenProperties = new TokenProperties();
            tokenProperties.setTokenTtl(userDetailExtendDTO.getTokenTtl());
            tokenProperties.setRefreshTokenTtl(userDetailExtendDTO.getRefreshTokenTtl());
            return tokenProperties;
        }

        // 再去查询
        var clientId = CharSequenceUtil.blankToDefault(request.getParameter(LoginParameterNames.CLIENT_ID), request.getHeader(AuthorizationConstant.REQUEST_ATTRIBUTE_CLIENT_ID));
        if (CharSequenceUtil.isBlank(clientId)) {
            clientId = sdkProperties.getCasClient().getOauth2Client().getClientId();
        }
        if (CharSequenceUtil.isBlank(clientId)) {
            return this.defaultTokenProperties();
        }
        var result = userTransferHelper.validateClientUser(clientId, null);
        if (result.getData() == null) {
            throw new AuthorizationException(result.getMsg());
        }

        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(result.getData().getTokenTtl());
        tokenProperties.setRefreshTokenTtl(result.getData().getRefreshTokenTtl());

        return tokenProperties;
    }

    private TokenProperties defaultTokenProperties() {;
        TokenProperties tokenProperties = new TokenProperties();
        tokenProperties.setTokenTtl(authorizationProperties.getTokenTtl());
        tokenProperties.setRefreshTokenTtl(authorizationProperties.getRefreshTokenTtl());

        return tokenProperties;
    }
}
