package com.elitescloud.boot.auth.provider.common;

import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;

/**
 * 登录相关请求参数名称.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public interface LoginParameterNames {

    /**
     * 登录终端
     */
    String TERMINAL = "terminal";

    /**
     * 登录类型
     */
    String LOGIN_TYPE = "login_type";

    /**
     * 客户端标识
     */
    String CLIENT_ID = "client_id";

    /**
     * 平台编码
     */
    String PLATFORM = "platform_code";

    /**
     * 用户名
     */
    String USERNAME = OAuth2ParameterNames.USERNAME;

    /**
     * 密码
     */
    String PASSWORD = OAuth2ParameterNames.PASSWORD;

    /**
     * 账号
     */
    String ACCOUNT = "account";

    /**
     * 账号类型
     */
    String ACCOUNT_TYPE = "account_type";

    /**
     * 手机号
     */
    String MOBILE = "mobile";

    /**
     * 手机IMEI
     */
    String MOBILE_IMEI = "deviceCode";

    /**
     * 手机短信验证码
     */
    String MOBILE_SMS_CODE = "sms_code";

    /**
     * 自动注册
     */
    String AUTO_REGISTER = "auto_register";

    /**
     * 邮箱
     */
    String EMAIL = "email";

    /**
     * 手机短信验证码
     */
    String EMAIL_CODE = "email_code";

    /**
     * 微信-appid
     */
    String WECHAT_APPID = "wx_appid";

    /**
     * 微信-code
     */
    String WECHAT_CODE = "wx_code";

    /**
     * 微信用户-openid
     */
    String WECHAT_OPENID = "wx_openid";

    /**
     * 微信用户-unionid
     */
    String WECHAT_UNIONID = "wx_unionid";

    /**
     * 微信的应用ID
     */
    String WECHAT_AGENTID = "wx_agentid";

    /**
     * 支付宝-响应
     */
    String ALIPAY_RESP = "alipay_resp";

    /**
     * 支付宝-授权码
     */
    String ALIPAY_CODE = "alipay_code";

    /**
     * 支付宝-应用ID
     */
    String ALIPAY_APPID = "alipay_appid";

    /**
     * 支付宝-openid
     */
    String ALIPAY_OPENID = "alipay_openid";

    /**
     * 支付宝-unionid
     */
    String ALIPAY_UNIONID = "alipay_unionid";

    /**
     * 支付宝-优先用户ID
     */
    String ALIPAY_PREFER_USERID = "alipay_prefer_userid";

    /**
     * 是否需要验证码
     */
    String CAPTCHA_NEED = "captcha_needed";

    /**
     * 验证码-内容
     */
    String CAPTCHA_TEXT = "captcha";

    /**
     * 验证码-key
     */
    String CAPTCHA_UID = "capuid";

    /**
     * 身份类型
     */
    String IDENTITY_TYPE = "identity";

    /**
     * 身份类型名称
     */
    String IDENTITY_TYPE_NAME = "identity_name";

    /**
     * 记住我
     */
    String REMEMBER_ME = "remember_me";

    /**
     * LDAP的属性条件
     */
    String LDAP_ATTRS = "ldap_attrs";

    /**
     * 重定向路径
     */
    String REDIRECT_URL = "redirectUrl";
}
