package com.elitescloud.boot.auth.provider.common.param;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 支付宝配置.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/5
 */
@Getter
@Setter
public class AlipayApp implements Serializable {
    private static final long serialVersionUID = 7145995377657894353L;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * AES秘钥
     */
    private String aesKey;
    /**
     * 私钥
     */
    private String privateKey;
    /**
     * 公钥
     */
    private String publicKey;
    /**
     * 支付宝公钥
     */
    private String publicKeyAlipay;

    /**
     * 是否优先使用用户ID
     */
    private boolean preferUserId = false;
}
