package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.provider.config.system.*;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * 系统配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@EnableConfigurationProperties({ConfigProperties.class, WechatProperties.class, WecomProperties.class, TenantProperties.class,
        AlipayProperties.class})
@EnableScheduling
@EnableCaching
@Import({SystemConfig.TenantConfig.class, SystemConfig.SwaggerConfig.class})
@ConditionalOnClass({CloudtCoreAutoConfiguration.class})
@Log4j2
class SystemConfig {

    /**
     * 当存在租户时的配置
     */
    @ConditionalOnClass({TenantClient.class})
    static class TenantConfig {

        /**
         * 用户认证时租户相关检查
         *
         * @param tenantProperties
         * @param tenantClientProvider
         * @return
         */
        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties,
                                                                           TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }

    @ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
    static class SwaggerConfig extends BaseSwaggerConfig {

        public SwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
            super(openApiExtensionResolver, serverProperties);
        }

        @Bean
        public Docket createAuthProviderRestApi() {
            return createDocket("AuthorizationSupportAPI", "com.elitescloud.boot.auth");
        }
    }
}
