package com.elitescloud.boot.auth.provider.config.properties;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.common.LoginAccountType;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashMap;
import java.util.Map;

/**
 * LDAP认证配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/10/7
 */
@ConfigurationProperties(prefix = LdapProperties.CONFIG_PREFIX)
public class LdapProperties {
    public static final String CONFIG_PREFIX = AuthorizationProperties.CONFIG_PREFIX + ".ldap";

    /**
     * 是否启用
     */
    private boolean enabled = false;

    /**
     * 服务端路径
     */
    private String[] urls;

    /**
     * 基本后缀
     */
    private String base;

    /**
     * 服务端账号
     */
    private String username;

    /**
     * 服务端密码
     */
    private String password;

    /**
     * 只读操作是否匿名
     */
    private Boolean anonymousReadOnly;

    /**
     * 其它LDAP设置
     */
    private final Map<String, String> baseEnvironment = new HashMap<>();

    /**
     * LdapTemplate配置
     */
    private final Template template = new Template();

    /**
     * 登录属性
     */
    private String loginAttributeName = "uid";

    /**
     * LDAP账号对应我们系统的账号类型
     */
    private LoginAccountType loginAccountType = LoginAccountType.USERNAME;

    /**
     * 登录的通用属性
     */
    private Map<String, Object> loginAttributes = new HashMap<>();

    /**
     * 认证失败时的消息
     */
    private String authenticatedFailMsg = "账户或密码错误";

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getUrls() {
        return urls;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public String getBase() {
        return base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getAnonymousReadOnly() {
        return anonymousReadOnly;
    }

    public void setAnonymousReadOnly(Boolean anonymousReadOnly) {
        this.anonymousReadOnly = anonymousReadOnly;
    }

    public Map<String, String> getBaseEnvironment() {
        return baseEnvironment;
    }

    public Template getTemplate() {
        return template;
    }

    public String getLoginAttributeName() {
        return loginAttributeName;
    }

    public void setLoginAttributeName(String loginAttributeName) {
        this.loginAttributeName = loginAttributeName;
    }

    public LoginAccountType getLoginAccountType() {
        return loginAccountType;
    }

    public void setLoginAccountType(LoginAccountType loginAccountType) {
        this.loginAccountType = loginAccountType;
    }

    public Map<String, Object> getLoginAttributes() {
        return loginAttributes;
    }

    public void setLoginAttributes(Map<String, Object> loginAttributes) {
        this.loginAttributes = loginAttributes;
    }

    public String getAuthenticatedFailMsg() {
        return authenticatedFailMsg;
    }

    public void setAuthenticatedFailMsg(String authenticatedFailMsg) {
        this.authenticatedFailMsg = authenticatedFailMsg;
    }

    public static class Template {
        /**
         * 是否忽略PartialResultException.
         */
        private boolean ignorePartialResultException = false;

        /**
         * 是否忽略NameNotFoundException.
         */
        private boolean ignoreNameNotFoundException = false;

        /**
         * 是否忽略SizeLimitExceededException异常.
         */
        private boolean ignoreSizeLimitExceededException = true;

        public boolean isIgnorePartialResultException() {
            return ignorePartialResultException;
        }

        public void setIgnorePartialResultException(boolean ignorePartialResultException) {
            this.ignorePartialResultException = ignorePartialResultException;
        }

        public boolean isIgnoreNameNotFoundException() {
            return ignoreNameNotFoundException;
        }

        public void setIgnoreNameNotFoundException(boolean ignoreNameNotFoundException) {
            this.ignoreNameNotFoundException = ignoreNameNotFoundException;
        }

        public boolean isIgnoreSizeLimitExceededException() {
            return ignoreSizeLimitExceededException;
        }

        public void setIgnoreSizeLimitExceededException(boolean ignoreSizeLimitExceededException) {
            this.ignoreSizeLimitExceededException = ignoreSizeLimitExceededException;
        }
    }
}
