package com.elitescloud.boot.auth.provider.config.properties;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.sso.common.SsoAccountType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.Duration;

/**
 * SSO属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
@ConfigurationProperties(prefix = Sso2Properties.CONFIG_PREFIX)
public class Sso2Properties {
    public static final String CONFIG_PREFIX = AuthorizationProperties.CONFIG_PREFIX + ".sso";

    /**
     * 服务端配置
     */
    @NestedConfigurationProperty
    private Server server = new Server();

    /**
     * 客户端配置
     */
    @NestedConfigurationProperty
    private Client client = new Client();

    public Server getServer() {
        return server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Client getClient() {
        return client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    /**
     * 服务端配置
     */
    public static class Server {

        /**
         * 是否启用
         */
        private Boolean enabled = false;

        /**
         * 票据有效期
         */
        private Duration ticketTtl = Duration.ofMinutes(30);

        /**
         * 是否在ticket使用过后就失效
         */
        private Boolean expireTicketOnUsed = true;

        /**
         * 是否校验客户端
         */
        private Boolean validateClient = true;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getTicketTtl() {
            return ticketTtl;
        }

        public void setTicketTtl(Duration ticketTtl) {
            this.ticketTtl = ticketTtl;
        }

        public Boolean getExpireTicketOnUsed() {
            return expireTicketOnUsed;
        }

        public void setExpireTicketOnUsed(Boolean expireTicketOnUsed) {
            this.expireTicketOnUsed = expireTicketOnUsed;
        }

        public Boolean getValidateClient() {
            return validateClient;
        }

        public void setValidateClient(Boolean validateClient) {
            this.validateClient = validateClient;
        }
    }

    /**
     * 客户端配置
     */
    public static class Client {
        /**
         * 是否启用
         */
        private Boolean enabled = false;

        /**
         * 服务端地址
         */
        private String serverAddr;

        /**
         * 客户端ID
         */
        private String clientId;

        /**
         * 客户端密码
         */
        private String clientSecret;

        /**
         * 认证账号类型
         */
        private SsoAccountType accountType = SsoAccountType.USER_NAME;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getServerAddr() {
            return serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public SsoAccountType getAccountType() {
            return accountType;
        }

        public void setAccountType(SsoAccountType accountType) {
            this.accountType = accountType;
        }
    }
}
