package com.elitescloud.boot.auth.provider.config.servlet.oauth2;

import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.Duration;

/**
 * 授权码认证请求缓存.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/3
 */
public interface OAuth2AuthorizationCodeRequestCache {

    /**
     * 设置缓存
     *
     * @param reqId
     * @param authenticationToken
     * @param timeToLive
     */
    void setAuthenticationToken(@NotBlank String reqId, @NotNull OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken, Duration timeToLive);

    /**
     * 获取缓存
     *
     * @param reqId
     * @return
     */
    OAuth2AuthorizationCodeRequestAuthenticationToken getAuthenticationToken(@NotBlank String reqId);

    /**
     * 移除缓存
     *
     * @param reqId
     */
    void removeAuthenticationToken(@NotBlank String reqId);
}
