package com.elitescloud.boot.auth.provider.provider.user;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;

import javax.validation.constraints.NotBlank;

/**
 * 登录用户管理.
 * <p>
 * 用以登录时获取用户相关信息
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/06
 */
public interface UserDetailManager {

    /**
     * 根据用户名加载用户信息
     *
     * @param username 用户名
     * @return 用户信息
     */
    GeneralUserDetails loadUserByUsername(@NotBlank String username);

    /**
     * 根据手机号加载用户信息
     *
     * @param mobile 手机号
     * @return 用户信息
     */
    GeneralUserDetails loadUserByMobile(@NotBlank String mobile);

    /**
     * 根据手机号和IMEI加载用户信息
     *
     * @param mobile 手机号
     * @param imei IMEI编号
     * @return 用户信息
     */
    GeneralUserDetails loadUserByMobileIMEI(@NotBlank String mobile, @NotBlank String imei);

    /**
     * 当根据手机号加载用户信息失败时自动注册用户
     *
     * @param mobile 手机号
     * @return 用户信息
     */
    GeneralUserDetails registerOnLoadUserByMobileNotFound(@NotBlank String mobile);

    /**
     * 根据邮箱加载用户信息
     *
     * @param email 邮箱
     * @return 用户信息
     */
    GeneralUserDetails loadUserByEmail(@NotBlank String email);

    /**
     * 当根据邮箱加载用户信息失败时自动注册用户
     *
     * @param email 邮箱
     * @return 用户信息
     */
    GeneralUserDetails registerOnLoadUserByEmailNotFound(@NotBlank String email);

    /**
     * 根据用户ID加载用户信息
     *
     * @param userId 用户ID
     * @return 用户信息
     */
    GeneralUserDetails loadUserById(@NotBlank String userId);

    /**
     * 根据账号加载用户信息
     * <p>
     * 使用account到多个表字段进行匹配，如登录号、手机号和邮箱等
     *
     * @param account 账号
     * @return 用户信息
     */
    GeneralUserDetails loadUserByAccount(@NotBlank String account);

    /**
     * 根据用户openid加载用户信息
     *
     * @param wechatOpenid 微信openId
     * @return 用户信息
     * @deprecated 已废弃，请使用{@link #loadUserByOpenId(String, String)}
     */
    @Deprecated
    GeneralUserDetails loadUserByWechatOpenid(@NotBlank String wechatOpenid);

    /**
     * 根据OpenID 加载用户信息
     *
     * @param appId  外部应用ID
     * @param openId 在外边应用中的账号openID
     * @return 用户信息
     */
    GeneralUserDetails loadUserByOpenId(@NotBlank String appId, @NotBlank String openId);
}
