package com.elitescloud.boot.auth.provider.security.generator.ticket;

import cn.hutool.core.util.IdUtil;
import com.elitescloud.boot.auth.client.common.SecurityConstants;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.log4j.Log4j2;
import org.springframework.util.StringUtils;

/**
 * redis ticket生成器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
@Log4j2
public class RedisTicketGenerator implements TicketGenerator {

    private final RedisHelper redisHelper;

    public RedisTicketGenerator(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public String generate(SysUserDTO user) {
        String ticket = IdUtil.fastSimpleUUID();
        UserInfoDTO userInfoDTO = TicketGenerator.userToUserInfoDto(user);

        try {
            redisHelper.execute(redisUtils -> redisUtils.set(SecurityConstants.CACHE_PREFIX_SSO_TICKET + ticket, userInfoDTO));
        } catch (Exception e) {
            log.error("缓存用户ticket异常：", e);
            throw new BusinessException("生成ticket失败", e);
        }

        log.info("用户{}生成ticket：{}", user.getUsername(), ticket);

        return ticket;
    }

    @Override
    public UserInfoDTO validate(String ticket) {
        if (StringUtils.hasText(ticket)) {
            try {
                return (UserInfoDTO) redisHelper.execute(redisUtils -> redisUtils.get(SecurityConstants.CACHE_PREFIX_SSO_TICKET + ticket));
            } catch (Exception e) {
                log.error("根据ticket获取缓存用户ticket异常：", e);
                throw new BusinessException("校验ticket失败", e);
            }
        }
        return null;
    }

    @Override
    public void remove(String ticket) {
        if (StringUtils.hasText(ticket)) {
            try {
                redisHelper.execute(redisUtils -> {
                    redisUtils.del(SecurityConstants.CACHE_PREFIX_SSO_TICKET + ticket);
                    return null;
                });
            } catch (Exception e) {
                log.error("根据ticket删除缓存用户ticket异常：", e);
                throw new BusinessException("删除ticket失败", e);
            }
        }
    }
}
