package com.elitescloud.boot.auth.provider.security.grant;

import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;

/**
 * 是否密码可检查.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/6
 */
@FunctionalInterface
public interface CredentialCheckable {

    /**
     * 是否需要校验密码
     *
     * @param authenticationToken token
     * @param userDetails         用户信息
     * @return 是否需要校验
     */
    <T extends AbstractCustomAuthenticationToken<T>> boolean needCheck(T authenticationToken, GeneralUserDetails userDetails);
}
