package com.elitescloud.boot.auth.provider.security.grant.alipay_minapp;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 支付宝授权码的身份认证令牌.
 * <p>
 * 基于支付宝授权码的认证方式登录，<a href="https://opendocs.alipay.com/mini/0ai5vq?pathHash=4f29c6db">OpenID开发流程</a>
 *
 * @author Kaiser（wang shao）
 * @date 2025/02/05
 */
public class AlipayMinappAuthenticationToken extends AbstractCustomAuthenticationToken<AlipayMinappAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011389L;

    private String openId;
    private String unionId;
    private boolean preferUserId;

    public AlipayMinappAuthenticationToken() {
        super(null, null);
    }

    public AlipayMinappAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public AlipayMinappAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public boolean isPreferUserId() {
        return preferUserId;
    }

    public void setPreferUserId(boolean preferUserId) {
        this.preferUserId = preferUserId;
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.ALIPAY_MINI;
    }

    @NonNull
    @Override
    public AlipayMinappAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        AlipayMinappAuthenticationToken authenticationToken = new AlipayMinappAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.ALIPAY_APPID));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.ALIPAY_CODE));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setOpenId(parameters.getFirst(LoginParameterNames.ALIPAY_OPENID));
        authenticationToken.setUnionId(parameters.getFirst(LoginParameterNames.ALIPAY_UNIONID));
        authenticationToken.setPreferUserId(Boolean.parseBoolean(parameters.getFirst(LoginParameterNames.ALIPAY_PREFER_USERID)));

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        return authenticationToken;
    }
}
