package com.elitescloud.boot.auth.provider.security.grant.alipay_phone;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 支付宝手机号的身份认证令牌.
 * <p>
 * 基于支付宝手机号的认证方式登录，<a href="https://opendocs.alipay.com/mini/api/getphonenumber?pathHash=a67c2790">获取手机号</a>
 *
 * @author Kaiser（wang shao）
 * @date 2025/02/05
 */
public class AlipayPhoneAuthenticationToken extends AbstractCustomAuthenticationToken<AlipayPhoneAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011389L;

    /**
     * 账号不存在时是否自动 注册
     */
    private boolean autoRegister = false;

    public AlipayPhoneAuthenticationToken() {
        super(null, null);
    }

    public AlipayPhoneAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public AlipayPhoneAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    public boolean isAutoRegister() {
        return autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.ALIPAY_MOBILE;
    }

    @NonNull
    @Override
    public AlipayPhoneAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        AlipayPhoneAuthenticationToken authenticationToken = new AlipayPhoneAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.ALIPAY_APPID));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.ALIPAY_RESP));
        authenticationToken.setAutoRegister("true".equalsIgnoreCase(parameters.getFirst(LoginParameterNames.AUTO_REGISTER)));
        authenticationToken.setAuthenticated(false);

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        return authenticationToken;
    }
}
