package com.elitescloud.boot.auth.provider.security.grant.ldap;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.boot.auth.provider.security.grant.email_code.EmailCodeAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * LDAP认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2024/10/7
 */
public class LdapAuthenticationToken extends AbstractCustomAuthenticationToken<LdapAuthenticationToken> {
    private static final long serialVersionUID = 1932997481796678346L;

    private Map<String, Object> attributes;

    public LdapAuthenticationToken() {
        super(null, null);
    }

    public LdapAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public LdapAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.LDAP;
    }

    @NonNull
    @Override
    public LdapAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.parse(terminalParam);
        }

        LdapAuthenticationToken authenticationToken = new LdapAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.USERNAME));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.PASSWORD));
        authenticationToken.setAuthenticated(false);

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        // 通用属性
        String attrs = parameters.getFirst(LoginParameterNames.LDAP_ATTRS);
        if (StringUtils.hasText(attrs)) {
            Map<String, Object> attrMap = Arrays.stream(attrs.split("&")).map(t -> t.split("="))
                    .filter(t -> StringUtils.hasText(t[0]) && StringUtils.hasText(t[1]))
                    .collect(Collectors.toMap(t -> t[0], t -> t[1], (t1, t2) -> t1));
            authenticationToken.setAttributes(attrMap);
        }

        return authenticationToken;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}
