package com.elitescloud.boot.auth.provider.security.grant.mobile_pwd;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 手机号密码的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobilePasswordAuthenticationToken extends AbstractCustomAuthenticationToken<MobilePasswordAuthenticationToken> {
    private static final long serialVersionUID = -2118788872828941269L;

    /**
     * 验证码内容
     */
    private String captchaText;
    /**
     * 验证码key
     */
    private String captchaKey;
    /**
     * 是否必须验证码
     */
    private Boolean captchaNeeded;

    /**
     * 是否记住我
     */
    private Boolean rememberMe;

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    /**
     * 移动端IMEI
     */
    private String deviceCode;

    public MobilePasswordAuthenticationToken() {
        super(null, null);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobilePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.MOBILE_PWD;
    }

    @NonNull
    @Override
    public MobilePasswordAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        String captchaNeededStr = parameters.getFirst(LoginParameterNames.CAPTCHA_NEED);
        // 不为空且true时必须有验证码
        boolean captchaNeeded = Boolean.parseBoolean(captchaNeededStr);

        MobilePasswordAuthenticationToken authenticationToken = new MobilePasswordAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.MOBILE));
        authenticationToken.setCredentials(parameters.getFirst(OAuth2ParameterNames.PASSWORD));
        authenticationToken.setDeviceCode(parameters.getFirst(LoginParameterNames.MOBILE_IMEI));
        authenticationToken.setAuthenticated(false);

        authenticationToken.setCaptchaText(parameters.getFirst(LoginParameterNames.CAPTCHA_TEXT));
        authenticationToken.setCaptchaKey(parameters.getFirst(LoginParameterNames.CAPTCHA_UID));
        authenticationToken.setCaptchaNeeded(captchaNeeded);

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        authenticationToken.setRememberMe(Boolean.valueOf(parameters.getFirst(LoginParameterNames.REMEMBER_ME)));

        return authenticationToken;
    }

    public String getCaptchaText() {
        return captchaText;
    }

    public void setCaptchaText(String captchaText) {
        this.captchaText = captchaText;
    }

    public String getCaptchaKey() {
        return captchaKey;
    }

    public void setCaptchaKey(String captchaKey) {
        this.captchaKey = captchaKey;
    }

    public Boolean getCaptchaNeeded() {
        return captchaNeeded;
    }

    public void setCaptchaNeeded(Boolean captchaNeeded) {
        this.captchaNeeded = captchaNeeded;
    }

    public Boolean getRememberMe() {
        return rememberMe;
    }

    public void setRememberMe(Boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}
