package com.elitescloud.boot.auth.provider.security.grant.mobile_sms;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.jackson.mixin.grant.MixinMobileSmsAuthenticationToken;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 手机号和短信的身份证认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobileSmsAuthenticationProvider extends AbstractCustomAuthenticationProvider<MobileSmsAuthenticationToken> {

    private VerifyCodeManager verifyCodeManager;

    @NonNull
    @Override
    protected GeneralUserDetails retrieveUser(MobileSmsAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(mobile)) {
            throw new AuthorizationException("手机号为空");
        }

        String smsCode = (String) authentication.getCredentials();
        if (!StringUtils.hasText(smsCode)) {
            throw new AuthorizationException("验证码为空");
        }
        if (authentication.isAutoRegister() && Boolean.FALSE.equals(configProperties.getLogin().getAutoRegister())) {
            throw new AuthorizationException("不支持自动注册账号");
        }

        // 校验短信验证码
        String failMsg = verifyCodeManager.verify(VerifyCodeManager.BUSINESS_TYPE_AUTH_LOGIN, mobile, smsCode);
        if (failMsg != null) {
            throw new AuthorizationException("手机号错误或验证码已过期");
        }

        var user = authentication.isAutoRegister() ? userDetailManager.registerOnLoadUserByMobileNotFound(mobile) :
                userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("手机号错误或验证码已过期");
        }
        return user;
    }

    @Override
    public Class<MobileSmsAuthenticationToken> getAuthenticationTokenType() {
        return MobileSmsAuthenticationToken.class;
    }

    @Override
    public Class<?> getMixinAuthenticationTokenType() {
        return MixinMobileSmsAuthenticationToken.class;
    }

    @Autowired
    public void setVerifyCodeManager(VerifyCodeManager verifyCodeManager) {
        this.verifyCodeManager = verifyCodeManager;
    }
}
