package com.elitescloud.boot.auth.provider.security.grant.wechat_minapp;

import com.elitescloud.boot.auth.client.common.LoginType;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 微信openid的身份认证令牌.
 *
 * 基于小程序的openid登录方式，<a href="https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/login.html">小程序登录</a>
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class WechatMinAppAuthenticationToken extends AbstractCustomAuthenticationToken<WechatMinAppAuthenticationToken> {
    private static final long serialVersionUID = 35697051927011289L;

    private String openId;
    private String unionId;

    public WechatMinAppAuthenticationToken() {
        super(null, null);
    }

    public WechatMinAppAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public WechatMinAppAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.WX_MINAPP;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    @NonNull
    @Override
    public WechatMinAppAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        WechatMinAppAuthenticationToken authenticationToken = new WechatMinAppAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.WECHAT_APPID));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.WECHAT_CODE));
        authenticationToken.setOpenId(parameters.getFirst(LoginParameterNames.WECHAT_OPENID));
        authenticationToken.setUnionId(parameters.getFirst(LoginParameterNames.WECHAT_UNIONID));
        authenticationToken.setAuthenticated(false);

        // 账号类型
        authenticationToken.setIdentity(parameters.getFirst(LoginParameterNames.IDENTITY_TYPE));

        return authenticationToken;
    }
}
