package com.elitescloud.boot.auth.provider.security.handler;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;

/**
 * 认证成功后的回调.
 * <p>
 * 缓存用户信息
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
@Log4j2
public class CacheUserAuthenticationCallable implements AuthenticationCallable {

    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;
    private final TokenPropertiesProvider tokenPropertiesProvider;

    public CacheUserAuthenticationCallable(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache,
                                           TokenPropertiesProvider tokenPropertiesProvider) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
        this.tokenPropertiesProvider = tokenPropertiesProvider;
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
        GeneralUserDetails user = null;
        if (authentication.getPrincipal() instanceof GeneralUserDetails) {
            user = (GeneralUserDetails) authentication.getPrincipal();
        }

        if (user != null && StringUtils.hasText(token)) {
            log.info("用户{}登录，token：{}", user.getUsername(), token);
            authenticationCache.setUserDetail(token, user, cachePrincipalDuration());
        }
    }

    @Override
    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (!StringUtils.hasText(token)) {
            return;
        }
        if (principal instanceof GeneralUserDetails) {
            log.info("用户{}注销", ((GeneralUserDetails)principal).getUsername());
        }

        authenticationCache.removeUserDetail(token);
    }

    private Duration cachePrincipalDuration() {
        var tokenProperties = tokenPropertiesProvider.get();
        if (tokenProperties != null) {
            return tokenProperties.getTokenTtl();
        }

        if (authorizationProperties.getTokenTtl() != null && authorizationProperties.getTokenTtl().getSeconds() > 0) {
            return authorizationProperties.getTokenTtl();
        }
        return null;
    }
}
