package com.elitescloud.boot.auth.provider.security.jackson.mixin.grant;

import com.elitescloud.boot.auth.provider.CustomAuthenticationProvider;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;

import java.util.ServiceLoader;

/**
 * 自定义jacksonModule.
 * <p>
 * 支持自定义AuthenticationToken类的反序列化
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/07
 */
public class CustomAuthenticationTokenJacksonModule extends SimpleModule {
    private static final long serialVersionUID = -3294671195482929553L;

    public CustomAuthenticationTokenJacksonModule() {
        super(CustomAuthenticationTokenJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    @Override
    public void setupModule(SetupContext context) {
        ServiceLoader.load(CustomAuthenticationProvider.class).stream()
                .filter(t -> AbstractCustomAuthenticationProvider.class.isAssignableFrom(t.type()))
                .forEach(t -> {
                    var authenticationProvider = (AbstractCustomAuthenticationProvider<?>) t.get();
                    context.setMixInAnnotations(authenticationProvider.getAuthenticationTokenType(), authenticationProvider.getMixinAuthenticationTokenType());
                });
    }
}
