package com.elitescloud.boot.auth.provider.sso;

import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.common.base.ApiResult;

/**
 * sso登录支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
public interface SsoLoginSupportProvider {

    /**
     * 生成ticket
     *
     * @param account
     * @param accountType
     * @return
     */
    ApiResult<String> generateTicket(String account, String accountType);

    /**
     * 根据ticket获取用户信息
     *
     * @param ticket
     * @return
     */
    ApiResult<UserInfoDTO> getUserInfo(String ticket);

}
