package com.elitescloud.boot.auth.provider.sso2.common;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 票据生成器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/26
 */
public interface TicketProvider {

    /**
     * 生成票据
     *
     * @param request  request
     * @param response response
     * @return 票据
     */
    String generateTicket(HttpServletRequest request, HttpServletResponse response);

    /**
     * 置换票据
     *
     * @param ticket
     * @return
     */
    Object exchangeTicket(String ticket);
}
