package com.elitescloud.boot.auth.provider.cas.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 认证配置信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/16
 */
@Data
@ApiModel(description = "认证配置信息")
public class AuthorizeSettingVO {

    @ApiModelProperty(value = "是否启用统一身份认证", position = 1)
    private Boolean enabled;

    @ApiModelProperty(value = "统一身份认证地址", position = 2)
    private String authorizeUrl;

    @ApiModelProperty(value = "注销地址", position = 3)
    private String logoutUrl;

    @ApiModelProperty(value = "统一身份认证服务器地址", position = 4)
    private String authServer;

    @ApiModelProperty(value = "扩展属性", position = 5)
    private Serializable customizeAttr;
}
