package com.elitescloud.boot.auth.provider.config.properties;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.sso.common.SsoAccountType;
import com.elitescloud.boot.common.ParamIn;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * SSO属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
@ConfigurationProperties(prefix = Sso2Properties.CONFIG_PREFIX)
public class Sso2Properties {
    public static final String CONFIG_PREFIX = AuthorizationProperties.CONFIG_PREFIX + ".sso";

    /**
     * 服务端配置
     */
    @NestedConfigurationProperty
    private Server server = new Server();

    /**
     * 客户端配置
     */
    @NestedConfigurationProperty
    private Client client = new Client();

    /**
     * 统一客户端配置
     */
    @NestedConfigurationProperty
    private UnifyClient unifyClient = new UnifyClient();

    public Server getServer() {
        return server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Client getClient() {
        return client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public UnifyClient getUnifyClient() {
        return unifyClient;
    }

    public void setUnifyClient(UnifyClient unifyClient) {
        this.unifyClient = unifyClient;
    }

    /**
     * 服务端配置
     */
    public static class Server {

        /**
         * 是否启用
         */
        private Boolean enabled = false;

        /**
         * 票据有效期
         */
        private Duration ticketTtl = Duration.ofMinutes(30);

        /**
         * 是否在ticket使用过后就失效
         */
        private Boolean expireTicketOnUsed = true;

        /**
         * 是否校验客户端
         */
        private Boolean validateClient = true;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getTicketTtl() {
            return ticketTtl;
        }

        public void setTicketTtl(Duration ticketTtl) {
            this.ticketTtl = ticketTtl;
        }

        public Boolean getExpireTicketOnUsed() {
            return expireTicketOnUsed;
        }

        public void setExpireTicketOnUsed(Boolean expireTicketOnUsed) {
            this.expireTicketOnUsed = expireTicketOnUsed;
        }

        public Boolean getValidateClient() {
            return validateClient;
        }

        public void setValidateClient(Boolean validateClient) {
            this.validateClient = validateClient;
        }
    }

    /**
     * 客户端配置
     */
    public static class Client {
        /**
         * 是否启用
         */
        private Boolean enabled = false;

        /**
         * 服务端地址
         */
        private String serverAddr;

        /**
         * 客户端ID
         */
        private String clientId;

        /**
         * 客户端密码
         */
        private String clientSecret;

        /**
         * 认证账号类型
         */
        private SsoAccountType accountType = SsoAccountType.USER_NAME;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getServerAddr() {
            return serverAddr;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public SsoAccountType getAccountType() {
            return accountType;
        }

        public void setAccountType(SsoAccountType accountType) {
            this.accountType = accountType;
        }
    }

    /**
     * 统一客户端配置
     */
    public static class UnifyClient {

        /**
         * 客户端配置
         */
        private List<UnifyClientProperty> clients = new ArrayList<>();

        public List<UnifyClientProperty> getClients() {
            return clients;
        }

        public void setClients(List<UnifyClientProperty> clients) {
            this.clients = clients;
        }
    }

    public static class UnifyClientProperty {
        /**
         * 是否启用
         */
        private boolean enabled = true;

        /**
         * 认证编码
         */
        private String authCode;

        /**
         * 单点登录类型
         */
        private SsoTypeEnum ssoType;

        /**
         * 参数名称
         */
        private String paramName;

        /**
         * 参数位置
         */
        private ParamIn paramIn = ParamIn.QUERY;

        /**
         * 参数映射
         */
        private InternalAuthenticationGranter.IdType idType = InternalAuthenticationGranter.IdType.USERNAME;

        /**
         * 统一客户端ID
         */
        private String clientId;

        /**
         * 统一客户端密码
         */
        private String clientSecret;

        /**
         * 属性配置
         */
        private Properties properties;

        public String getParamName() {
            return paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public ParamIn getParamIn() {
            return paramIn;
        }

        public void setParamIn(ParamIn paramIn) {
            this.paramIn = paramIn;
        }

        public InternalAuthenticationGranter.IdType getIdType() {
            return idType;
        }

        public void setIdType(InternalAuthenticationGranter.IdType idType) {
            this.idType = idType;
        }

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SsoTypeEnum getSsoType() {
            return ssoType;
        }

        public void setSsoType(SsoTypeEnum ssoType) {
            this.ssoType = ssoType;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Properties getProperties() {
            return properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public String getAuthCode() {
            return authCode;
        }

        public void setAuthCode(String authCode) {
            this.authCode = authCode;
        }
    }
}
