package com.elitescloud.boot.auth.provider.config.system;

import com.elitescloud.boot.auth.provider.common.param.WechatAppTypeEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 微信小程序配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/10
 */
@ConfigurationProperties(prefix = "elitesland.wechat")
public class WechatProperties implements Serializable {

    private static final long serialVersionUID = 6248659068250008287L;

    /**
     * 微信配置
     */
    private final List<App> apps = new ArrayList<>(4);

    public List<App> getApps() {
        return apps;
    }

    public static class App implements Serializable {
        private static final long serialVersionUID = -8821581764160725358L;

        /**
         * 设置微信的appid
         */
        private String appid;

        /**
         * 设置微信的Secret
         */
        private String secret;

        /**
         * 应用类型
         */
        private WechatAppTypeEnum appType = WechatAppTypeEnum.APPLET;

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public WechatAppTypeEnum getAppType() {
            return appType;
        }

        public void setAppType(WechatAppTypeEnum appType) {
            this.appType = appType;
        }
    }
}
