package com.elitescloud.boot.auth.provider.provider.wechat.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WechatApp;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import org.springframework.util.CollectionUtils;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/23
 */
public class DefaultWechatAppProvider implements WechatAppProvider {

    private final WechatProperties wechatProperties;

    public DefaultWechatAppProvider(WechatProperties wechatProperties) {
        this.wechatProperties = wechatProperties;
    }

    @Override
    public WechatApp getApp(String appId) {
        if (CollectionUtils.isEmpty(wechatProperties.getApps())) {
            return null;
        }

        for (WechatProperties.App app : wechatProperties.getApps()) {
            if (CharSequenceUtil.equals(appId, app.getAppid())) {
                WechatApp wechatApp = new WechatApp();
                wechatApp.setAppid(app.getAppid());
                wechatApp.setSecret(app.getSecret());
                wechatApp.setAppType(app.getAppType());

                return wechatApp;
            }
        }

        return null;
    }
}
