package com.elitescloud.boot.auth.provider.provider.wechat.param;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 微信手机号信息.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public class WechatPhoneInfo extends BaseWechatResult {

    /**
     * 手机号信息
     */
    @JsonProperty("phone_info")
    private PhoneInfo phoneInfo;

    public PhoneInfo getPhoneInfo() {
        return phoneInfo;
    }

    public void setPhoneInfo(PhoneInfo phoneInfo) {
        this.phoneInfo = phoneInfo;
    }

    public static class PhoneInfo {

        /**
         * 用户绑定的手机号（国外手机号会有区号）
         */
        @JsonProperty("phoneNumber")
        private String phoneNumber;

        /**
         * 没有区号的手机号
         */
        @JsonProperty("purePhoneNumber")
        private String purePhoneNumber;

        /**
         * 区号
         */
        @JsonProperty("countryCode")
        private String countryCode;

        public String getPhoneNumber() {
            return phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public String getPurePhoneNumber() {
            return purePhoneNumber;
        }

        public void setPurePhoneNumber(String purePhoneNumber) {
            this.purePhoneNumber = purePhoneNumber;
        }

        public String getCountryCode() {
            return countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }
    }
}
