package com.elitescloud.boot.auth.provider.sso2.common;

import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

/**
 * 单点登录令牌转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
public interface SsoAuthenticationConvert {

    /**
     * 支持类型
     *
     * @return 类型
     */
    @NotNull
    SsoTypeEnum supportType();

    /**
     * 参数类型
     *
     * @return 参数类型
     */
    @NotNull
    <T extends SsoConvertProperty> Class<T> propertyType();

    /**
     * 转换令牌
     *
     * @param request    请求
     * @param response   响应
     * @param properties 属性配置
     * @return 令牌
     */
    @Nullable
    <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(@NotNull HttpServletRequest request, HttpServletResponse response, T properties);
}
