package com.elitescloud.boot.auth.provider.sso2.controller;

import com.elitescloud.boot.auth.provider.sso2.support.SsoServerSupportProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 单点登录支持接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
@ResponseBody
@RequestMapping(value = "/oauth/sso/v2", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(tags = {"单点登录"})
public class SsoServerSupportController {

    private final SsoServerSupportProvider ssoSupportProvider;

    public SsoServerSupportController(SsoServerSupportProvider ssoSupportProvider) {
        this.ssoSupportProvider = ssoSupportProvider;
    }

    @ApiOperation(value = "获取ticket")
    @ApiOperationSupport(order = 1) @GetMapping(value = "/ticket")
    public ApiResult<String> getTicket(HttpServletRequest request, HttpServletResponse response) {
        return ssoSupportProvider.generateTicket(request, response);
    }

    /**
     * ticket换取用户信息
     *
     * @param request  请求信息
     * @param response 响应信息
     * @return 用户信息
     */
    @ApiOperation(value = "ticket换取用户信息", hidden = true)
    @ApiOperationSupport(order = 2)
    @RequestMapping(value = "/getUserByTicket", method = {RequestMethod.GET, RequestMethod.POST})
    public ApiResult<Object> getUserDetail(HttpServletRequest request, HttpServletResponse response) {
        return ssoSupportProvider.getUserDetail(request, response);
    }
}
