package com.elitescloud.boot.auth.provider.sso2.support;

import com.elitescloud.cloudt.common.base.ApiResult;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/20
 */
public interface SsoServerSupportProvider {

    /**
     * 生成票据
     *
     * @param request  请求信息
     * @param response 响应信息
     * @return 票据
     */
    ApiResult<String> generateTicket(HttpServletRequest request, HttpServletResponse response);

    /**
     * ticket换取用户信息
     *
     * @param request  请求信息
     * @param response 响应信息
     * @return 用户信息
     */
    ApiResult<Object> getUserDetail(HttpServletRequest request, HttpServletResponse response);

    /**
     * ticket换token
     *
     * @param ticket ticket
     * @return token
     */
    ApiResult<String> ticketToToken(@NotBlank String ticket);
}
