package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.BasicSsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.JwtSsoConvertProperty;
import com.elitescloud.boot.exception.BusinessException;
import org.jetbrains.annotations.Nullable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * 账户名和密码.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/8 周日
 */
public class BasicSsoAuthenticationConvert extends BasePlainSsoAuthenticationConvert {

    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.BASIC;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return (Class<T>) BasicSsoConvertProperty.class;
    }

    @Nullable
    @Override
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        JwtSsoConvertProperty props = (JwtSsoConvertProperty) properties;

        String value = getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank(value)) {
            throw new IllegalArgumentException("参数为空:" + props.getParamName());
        }

        String username = decodeBasicAuth(value);
        if (CharSequenceUtil.isBlank(username)) {
            throw new BusinessException("授权账户为空");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), username);

    }

    private String decodeBasicAuth(String basicAuth) {
        if (basicAuth.startsWith("Basic ") || basicAuth.startsWith("basic ")) {
            basicAuth = basicAuth.substring(6);
        }

        String credentialsString = new String(Base64.getDecoder().decode(basicAuth.getBytes(StandardCharsets.UTF_8)));
        String[] credentials = credentialsString.split(":");
        return URLDecoder.decode(credentials[0], StandardCharsets.UTF_8);
    }
}
