package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.PlainSsoConvertProperty;
import org.jetbrains.annotations.Nullable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 明文类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
public class PlainSsoAuthenticationConvert extends BasePlainSsoAuthenticationConvert {

    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.PLAIN;
    }

    @Override
    public Class propertyType() {
        return PlainSsoConvertProperty.class;
    }

    @Nullable
    @Override
    public InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, SsoConvertProperty properties) {
        PlainSsoConvertProperty props = (PlainSsoConvertProperty) properties;

        String value = getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank(value)) {
            throw new IllegalArgumentException("参数为空:" + props.getParamName());
        }

        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), value);
    }
}
