package com.elitescloud.boot.auth.provider.sso2.support.convert.properties;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * sso配置-JWT属性.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/6 周五
 */
@Getter
@Setter
public class JwtSsoConvertProperty extends SsoConvertProperty {
    private static final long serialVersionUID = 3616784717751521179L;

    /**
     * 负载中用户名称
     */
    private String payloadUserName = "sub";

    /**
     * 负载中用户名称路径
     */
    private String payloadUserNamePath;

    /**
     * 是否签名
     */
    private boolean signed = true;

    /**
     * 是否加密
     */
    private boolean encrypt = false;

    /**
     * 加密方式
     */
    private EncryptType encryptType = EncryptType.PASSWORD;

    /**
     * 加密密钥
     */
    private String encryptKey;

    /**
     * 签名方式
     */
    private SignType signType = SignType.HMAC;

    /**
     * 签名秘钥
     */
    private String signKey;

    /**
     * RSA密钥格式
     */
    private String rsaFormat = "X.509";

    public static enum EncryptType {
        RSA,
        AES,
        PASSWORD,
    }

    public static enum SignType {
        RSA,
        HMAC,
        ECDSA,
        NONE,
    }

    @Override
    public void validate() {
        super.validate();

        Assert.isTrue(CharSequenceUtil.isNotBlank(payloadUserName) ||  CharSequenceUtil.isNotBlank(payloadUserNamePath), "负载中用户名称字段不能为空");
    }
}
