package com.elitescloud.boot.auth.provider.sso2.support.convert.properties;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * sso配置-oidc.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/8 周日
 */
@Getter
@Setter
public class OidcSsoConvertProperty extends SsoConvertProperty {
    private static final long serialVersionUID = 2085848753141727631L;

    /**
     * 授权码换取token接口
     */
    private String accessTokenEndpoint;

    /**
     * 获取用户信息接口
     */
    private String userInfoEndpoint;

    /**
     * 授权服务的客户端id
     */
    private String authClientId;

    /**
     * 授权服务的客户端密钥
     */
    private String authClientSecret;

    /**
     * 授权码换取token时的回调地址
     */
    private String redirectUri;

    /**
     * 授权码换取token时的回调地址参数名
     */
    private String redirectUriParam;

    /**
     * 获取用户信息接口的参数路径
     */
    private String userInfoParamPath;

    @Override
    public void validate() {
        super.validate();

        Assert.notBlank(accessTokenEndpoint, "授权码换取token接口不能为空");
        Assert.notBlank(userInfoEndpoint, "获取用户信息接口不能为空");
        Assert.notBlank(authClientId, "授权服务的客户端id不能为空");
        Assert.notBlank(authClientSecret, "授权服务的客户端密钥不能为空");
        Assert.isTrue(CharSequenceUtil.isNotBlank(redirectUri) || CharSequenceUtil.isNotBlank(redirectUriParam), "授权码换取token时的回调地址不能为空");
        Assert.notBlank(userInfoParamPath, "用户信息的参数路径不能为空");
    }
}
