package com.elitescloud.boot.auth.provider.sso2.support.convert.properties;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.common.ParamIn;
import lombok.Getter;
import lombok.Setter;
import org.springframework.http.HttpMethod;

import java.util.Map;

/**
 * sso配置-ticket.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/8 周日
 */
@Getter
@Setter
public class TicketSsoConvertProperty extends SsoConvertProperty {
    private static final long serialVersionUID = -8623110872403026293L;

    /**
     * 用户信息接口地址
     */
    private String userInfoEndpoint;

    /**
     * 用户信息接口方法
     */
    private HttpMethod userInfoMethod = HttpMethod.GET;

    /**
     * ticket参数名称
     */
    private String ticketParamName = "ticket";

    /**
     * 用户信息接口扩展参数
     */
    private Map<String, String> userInfoAttributeMap;

    /**
     * 参数位置
     */
    private ParamIn userInfoParamIn = ParamIn.QUERY;

    /**
     * 用户信息参数位置
     * <p>
     * 如data.user
     */
    private String userInfoParamPath;

    @Override
    public void validate() {
        super.validate();

        Assert.notBlank(userInfoEndpoint, "用户信息接口地址不能为空");
    }
}
