/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.CloudtAuthorizationCacheAutoConfiguration;
import com.elitescloud.boot.auth.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.AuthenticationService;
import com.elitescloud.boot.auth.provider.config.CloudtCasClientConfig;
import com.elitescloud.boot.auth.provider.config.LdapConfig;
import com.elitescloud.boot.auth.provider.config.Sso2Config;
import com.elitescloud.boot.auth.provider.config.SsoConfig;
import com.elitescloud.boot.auth.provider.config.SystemConfig;
import com.elitescloud.boot.auth.provider.config.properties.AuthorizationProviderProperties;
import com.elitescloud.boot.auth.provider.config.servlet.ServletOAuth2ServerConfig;
import com.elitescloud.boot.auth.provider.config.servlet.ServletSingleConfig;
import com.elitescloud.boot.auth.provider.controller.LoginController;
import com.elitescloud.boot.auth.provider.provider.CloudtTokenCustomizer;
import com.elitescloud.boot.auth.provider.provider.DefaultTokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.auth.provider.security.TokenPropertiesProvider;
import com.elitescloud.boot.auth.provider.security.generator.token.JwtTokenGenerator;
import com.elitescloud.boot.auth.provider.security.generator.token.TokenGenerator;
import com.elitescloud.boot.auth.provider.security.grant.CredentialCheckable;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.security.handler.CacheUserAuthenticationCallable;
import com.elitescloud.boot.auth.provider.security.handler.LoginLogHandler;
import com.elitescloud.boot.auth.provider.security.handler.LogoutRedirectHandler;
import com.elitescloud.boot.auth.provider.security.impl.DefaultAuthenticationCheckServiceImpl;
import com.elitescloud.boot.auth.provider.security.impl.DefaultAuthenticationService;
import com.elitescloud.boot.auth.provider.security.listener.HttpSessionHolder;
import com.elitescloud.boot.auth.provider.security.listener.SessionEventApplicationListener;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.queue.LogEvent;
import com.elitescloud.boot.util.JwtUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.lmax.disruptor.RingBuffer;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.util.Assert;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableWebSecurity(debug=false)
@Import(value={ServletSingleConfig.class, ServletOAuth2ServerConfig.class, SystemConfig.class, SsoConfig.class, Sso2Config.class, LdapConfig.class, CloudtCasClientConfig.class, LoginLogConfig.class, HttpSessionConfig.class})
@AutoConfigureAfter(value={CloudtAuthorizationCacheAutoConfiguration.class})
public class AuthorizationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationAutoConfiguration.class);
    private final AuthorizationProperties authorizationProperties;

    public AuthorizationAutoConfiguration(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        Assert.notNull((Object)authorizationProperties.getType(), (String)"\u672a\u77e5\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f");
        log.info("\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f\uff1a{}", (Object)authorizationProperties.getType());
    }

    @Bean
    @ConditionalOnMissingBean
    TokenPropertiesProvider tokenPropertiesProviderDefault() {
        return new DefaultTokenPropertiesProvider(this.authorizationProperties);
    }

    @Bean
    OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizerCloudt(AuthorizationProviderProperties authorizationProviderProperties) {
        return new CloudtTokenCustomizer(authorizationProviderProperties);
    }

    @Bean
    public TokenGenerator tokenGenerator(RSAKey rsaKey, OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer, TokenPropertiesProvider tokenPropertiesProvider) {
        JwtEncoder jwtEncoder = JwtUtil.buildJwtEncoder((RSAKey)rsaKey);
        JwtTokenGenerator jwtTokenGenerator = new JwtTokenGenerator(jwtEncoder, tokenPropertiesProvider);
        jwtTokenGenerator.setTokenCustomizer(jwtCustomizer);
        return jwtTokenGenerator;
    }

    @Bean
    InternalAuthenticationGranter internalAuthenticationGranter(UserDetailManager userDetailManager, TokenGenerator tokenGenerator) {
        InternalAuthenticationGranter granter = new InternalAuthenticationGranter(userDetailManager, tokenGenerator);
        granter.setDelegateAuthenticationCallable(DelegateAuthenticationCallable.getInstance());
        return granter;
    }

    @Bean
    AuthenticationCallable authenticationCallableCacheUser(AuthenticationCache authenticationCache, AuthorizationProviderProperties authorizationProviderProperties, TokenPropertiesProvider tokenPropertiesProvider) {
        return new CacheUserAuthenticationCallable(this.authorizationProperties, authorizationProviderProperties, authenticationCache, tokenPropertiesProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    AuthenticationService authenticationService(@Autowired(required=false) LogoutRedirectHandler logoutRedirectHandler, @Autowired(required=false) InternalAuthenticationGranter internalAuthenticationGranter, AuthenticationCache authenticationCache) {
        return new DefaultAuthenticationService(DelegateAuthenticationCallable.getInstance(), logoutRedirectHandler, internalAuthenticationGranter, authenticationCache);
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationService.class})
    LoginController loginSupportController(AuthenticationService authenticationService) {
        return new LoginController(authenticationService);
    }

    @Bean
    AuthenticationCheckService defaultAuthenticationCheckService(AuthorizationProviderProperties configProperties, AuthenticationCache authenticationCache) {
        return new DefaultAuthenticationCheckServiceImpl(configProperties, authenticationCache);
    }

    @Bean
    HttpSessionHolder httpSessionHolder() {
        return new HttpSessionHolder();
    }

    @Bean
    ServletListenerRegistrationBean<HttpSessionHolder> servletListenerRegistrationBeanHttpSession() {
        ServletListenerRegistrationBean listenerRegistrationBean = new ServletListenerRegistrationBean();
        listenerRegistrationBean.setListener((EventListener)((Object)this.httpSessionHolder()));
        listenerRegistrationBean.setEnabled(true);
        return listenerRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    CredentialCheckable credentialCheckable() {
        return new CredentialCheckable(){

            @Override
            public <T extends AbstractCustomAuthenticationToken<T>> boolean needCheck(T authenticationToken, GeneralUserDetails userDetails) {
                return true;
            }
        };
    }

    @ConditionalOnClass(value={SessionRepositoryCustomizer.class})
    static class HttpSessionConfig {
        private final SessionProperties sessionProperties;

        public HttpSessionConfig(SessionProperties sessionProperties) {
            this.sessionProperties = sessionProperties;
        }

        @Bean
        SessionEventApplicationListener sessionEventApplicationListener() {
            return new SessionEventApplicationListener();
        }
    }

    @ConditionalOnProperty(prefix="elitesland.log.login-log", name={"enabled"}, havingValue="true")
    @EnableConfigurationProperties(value={LogProperties.class})
    static class LoginLogConfig {
        private final LogProperties logProperties;
        private final RingBuffer<LogEvent> ringBuffer;

        public LoginLogConfig(LogProperties logProperties, RingBuffer<LogEvent> ringBuffer) {
            this.logProperties = logProperties;
            this.ringBuffer = ringBuffer;
            log.info("\u542f\u7528\u767b\u5f55\u65e5\u5fd7\u7eaa\u5f55");
        }

        @Bean
        public AuthenticationCallable authenticationCallbackLoginLog(final LoginLogHandler loginLogHandler) {
            return new AuthenticationCallable(){

                public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
                    loginLogHandler.loginLog(request, authentication, null);
                }

                public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @NotNull Authentication authentication, @NotNull AuthenticationException exception) {
                    loginLogHandler.loginLog(request, null, exception);
                }
            };
        }

        @Bean
        public LoginLogHandler loginLogHandler() {
            return new LoginLogHandler(this.ringBuffer, this.logProperties);
        }
    }
}

